//CTF_main.c - core control routines

#include "g_local.h"

char Address1[] = "www.captaindeath.com";

cvar_t *maxcaptures;
cvar_t *prop_enable;
cvar_t *curse_enable;
cvar_t *hook_enable;
cvar_t *hook_distance;
cvar_t *URL1;
cvar_t *URL2;
cvar_t *keep_admin_status;

CTF_Game_Struct CTFGame;
//Put here as not defined elsewhere
custom_t custom_list[1024];

char CTF_Version[8];

qboolean ServerNeedsReset;

qboolean HasRunOnce = false;

//This will copy the server vars as defined by the server op and store for default
//values - used for idle reset and return to public mode etc.
void RunOnceOnly(void)
{
	if(HasRunOnce == true)
	{
//		gi.dprintf("Defaults skipped\n");
		return;
	}
	strcpy(default_dmflags, dmflags->string);
	strcpy(default_password, password->string);
	strcpy(default_timelimit, timelimit->string);
	strcpy(default_fraglimit, fraglimit->string);
	strcpy(default_capturelimit, maxcaptures->string);
	HasRunOnce = true;
//	gi.dprintf("Defaults saved\n");
}

void VersionCheck(edict_t *ent)
{
	char buf[32];
	sprintf(buf, "%s $power2ver\n", CTF_Version);
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void VersionCheckFail(edict_t *ent, CheckKick Reason)
{
	char buf[256];
	
	switch(Reason)
	{
		case NO_CLIENT_FILES:
		{
			sprintf(buf,"Error \"You must have the POWER 2 client files to play. Download from: %s\"\n", Address1);
			break;
		}
		case OLD_CLIENT_FILES:
		{
			sprintf(buf,"Error \"POWER 2 has been updated. Download the latest version from: %s\"\n", Address1);
			break;
		}
	}
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void PrecacheCTFItems(gclient_t *client)
{
	gitem_t *item;
	
//Dummy item to allow the flag sounds to be precached
//	item = FindItem("Flag Holster");
//	client->pers.inventory[ITEM_INDEX(item)] = 1;
//	PrecacheItem(item);
//Give each player a grapple
	if(!hook_enable->value)
		return;
	item = FindItem("Harpoon");
	client->pers.inventory[ITEM_INDEX(item)] = 1;
//	client->pers.weapon = item;
//	client->pers.lastweapon = item;
}

void InitialiseCTF(void)
{
	maxcaptures = gi.cvar("maxcaptures", "200", CVAR_SERVERINFO);
	prop_enable = gi.cvar("prop_enable", "1", CVAR_SERVERINFO);
	hook_enable = gi.cvar("hook_enable", "1", CVAR_SERVERINFO);
	hook_distance = gi.cvar("hook_maxdist", "0", CVAR_SERVERINFO);
	curse_enable = gi.cvar("curse_enable", "1", CVAR_SERVERINFO);
	keep_admin_status = gi.cvar("keep_admin_status", "1", CVAR_LATCH);

	URL1 = gi.cvar("URL1", Address1, CVAR_SERVERINFO | CVAR_NOSET);

//prevent them from being changed
//	gi.cvar_set("URL1", Address1);
//Force the game to POWER 2
	gi.cvar_set("teamplay", "4");
	gi.cvar_set("deathmatch", "1");
	gi.cvar_set("dm_realmode", "0");
	gi.cvar_set("cashlimit", "0");

	RunOnceOnly();
	CTFGame.teamscore[0] = 0;
	CTFGame.teamscore[1] = 0;
	CTFGame.capture_time[0] = 0;
	CTFGame.capture_time[1] = 0;
	CTFGame.CrashedPlayerCheckTime = CTF_CRASHED_PLAYER_CHECK_DELAY;
	LoadMOTD();
	ServerNeedsReset = false;
//Control point init
	CTFGame.num_control_points = 0;
}

void CTFMapRotateEvent(void)
{
	int Count;
	edict_t* ent;
	
	InitialiseCTF();
	for(Count=0;Count<game.maxclients;Count++)
	{
		ent = g_edicts + 1 + Count;
		if(!ent)
			continue;
		if(!ent->inuse)
			continue;
		ent->client->resp.score = 0;
		ent->client->resp.deposited = 0;
//		ent->client->resp.PlayerData.Frags = 0;
//		ent->client->resp.PlayerData.TotalCaptures = 0;
		ent->client->resp.PlayerData.FirstSpawn = true;
		CTFPlayerResetGrapple(ent);
	}
}

//Call this from EndDMLevel in g_main.c and SetupMapVote in tourney.c to kill grapple hang sound
void CTFMapEndEvent(void)
{
	int Count;
	edict_t* ent;
	
	for(Count=0;Count<game.maxclients;Count++)
	{
		ent = g_edicts + 1 + Count;
		if(!ent)
			continue;
		if(!ent->inuse)
			continue;
		CTFPlayerResetGrapple(ent);
	}
}

edict_t* FindControl(edict_t *attacker)
{
	edict_t *find = NULL;

	while((find = G_Find(find, FOFS(classname), "power_control_point")) != NULL)
	{
		if(!find)
			return NULL;
//Is it controlled by the killers team?
		if(find->s.modelindex != attacker->client->pers.team)
			continue;
//Is it visible to the killer?
		if (!visible(find, attacker))
			continue;
		return find;
	}
	return NULL;
}

void CheckAwardDefendBonus(edict_t *target, edict_t *attacker)
{
//target is enemy just killed, attacker is killer
	edict_t *find = NULL;
//Call this from death routine in P_Client.c

	find = FindControl(attacker);
	if(!find)
		return;
//Was it visible to the enemy?
	if (!visible(find, target))
		return;
//Its within the allowed distance - award a bonus
//Change this to the area entity name
	gi.bprintf(PRINT_HIGH, "%s defends a %s control point.\n", attacker->client->pers.netname, team_names[attacker->client->pers.team]);
	attacker->client->resp.score += POWER_POINTS_CONTROL_PROTECT_BONUS;
}

